package ru.yandex.direct.scheduler.hourglass.implementations.monitoring.juggler;

import java.time.Duration;

import com.google.common.base.Joiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.juggler.JugglerEvent;
import ru.yandex.direct.juggler.JugglerSender;

public class HourglassJugglerSender {
    private static final Logger logger = LoggerFactory.getLogger(HourglassJugglerSender.class);

    private final JugglerSender jugglerSender;
    private static final Duration JUGGLER_EVENT_TIMEOUT = Duration.ofSeconds(10);

    public HourglassJugglerSender(JugglerSender jugglerSender) {
        this.jugglerSender = jugglerSender;
    }

    public void sendEventSafely(JugglerEvent event) {
        try {
            jugglerSender.sendEvent(event, JUGGLER_EVENT_TIMEOUT);
        } catch (RuntimeException e) {
            logger.warn("Failed to send event to juggler", e);
        }
    }

    public static String getPrefixedService(String service) {
        return Joiner.on(".").join("hourglass_scheduler", service);
    }
}
