package ru.yandex.direct.scheduler.hourglass.implementations.monitoring.juggler;

import java.time.Duration;

import ru.yandex.direct.juggler.JugglerEvent;
import ru.yandex.direct.juggler.JugglerStatus;
import ru.yandex.direct.scheduler.hourglass.implementations.monitoring.SchedulerPingListener;

import static ru.yandex.direct.scheduler.hourglass.implementations.monitoring.juggler.HourglassJugglerSender.getPrefixedService;

public class UptimeSchedulerPingListener implements SchedulerPingListener {
    public static final String UPTIME_SERVICE = getPrefixedService("uptime");
    private final HourglassJugglerSender jugglerSender;
    private long schedulerStartTime;

    public UptimeSchedulerPingListener(HourglassJugglerSender jugglerSender) {
        this.jugglerSender = jugglerSender;
    }

    @Override
    public void onPing() {
        if (schedulerStartTime == 0) {
            schedulerStartTime = System.nanoTime();
        }
        sendUptimeEvent();
    }

    private void sendUptimeEvent() {
        Duration uptime = Duration.ofNanos(System.nanoTime() - schedulerStartTime);
        JugglerStatus status;
        String description;
        if (uptime.compareTo(Duration.ofMinutes(90)) >= 0) {
            status = JugglerStatus.OK;
            description = "Шедулер работает достаточное время (более 1,5 часов)" +
                    ", чтобы убедиться в стабильном и надежном запуске задач.";
        } else if (uptime.compareTo(Duration.ofMinutes(30)) >= 0) {
            status = JugglerStatus.WARN;
            description = "Шедулер работает, но недостаточно долго (от 30 минут до 1,5 часов)" +
                    ", чтобы быть уверенными в запуске редких задач. Действуйте по своему усмотрению";
        } else {
            status = JugglerStatus.CRIT;
            description = "Шедулер запущен менее 30 минут, этого мало чтобы утверждать о правильной работе. " +
                    "Подождите некоторое время и проверьте заново (uptime, стабильность хостов, отсутствие падений)";
        }

        jugglerSender.sendEventSafely(new JugglerEvent(UPTIME_SERVICE, status, description));
    }
}
