package ru.yandex.direct.scheduler.hourglass.implementations.schedule;

import ru.yandex.direct.scheduler.hourglass.schedule.ScheduleInfo;
import ru.yandex.direct.scheduler.hourglass.schedule.ScheduleInfoConverter;
import ru.yandex.direct.utils.JsonUtils;

public class ScheduleInfoConverterImpl implements ScheduleInfoConverter {

    private Codec scheduleInfoCodec;

    public ScheduleInfoConverterImpl() {
        this(new Base64Codec());
    }

    public ScheduleInfoConverterImpl(Codec scheduleInfoCodec) {
        this.scheduleInfoCodec = scheduleInfoCodec;
    }

    @Override
    public ScheduleInfo getScheduleInfoFromEncodedString(String encodedString) {
        var decodedString = scheduleInfoCodec.decode(encodedString);
        return JsonUtils.fromJson(decodedString, ScheduleInfoImpl.class);
    }

    @Override
    public String serializeAndEncodeSchedule(ScheduleInfo scheduleInfo) {
        var serializedInfo = serializeSchedule(scheduleInfo);
        return scheduleInfoCodec.encode(serializedInfo);
    }

    @Override
    public String serializeSchedule(ScheduleInfo scheduleInfo) {
        return JsonUtils.toJson(scheduleInfo);
    }

}
