package ru.yandex.direct.scheduler.hourglass.implementations.schedule;

import java.util.List;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.scheduler.hourglass.implementations.schedule.modifiers.ModifierDataWithTypeImpl;
import ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies.ScheduleDataWithTypeImpl;
import ru.yandex.direct.scheduler.hourglass.schedule.ScheduleInfo;
import ru.yandex.direct.scheduler.hourglass.schedule.modifiers.ModifierDataWithType;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleDataWithType;

public class ScheduleInfoImpl implements ScheduleInfo {
    @JsonProperty
    private final List<ScheduleDataWithTypeImpl> strategies;
    @JsonProperty
    private final List<ModifierDataWithTypeImpl> modifiers;

    public ScheduleInfoImpl(
            @JsonProperty("strategies") List<ScheduleDataWithTypeImpl> strategies,
            @JsonProperty("modifiers") List<ModifierDataWithTypeImpl> modifiers) {
        this.modifiers = modifiers;
        this.strategies = strategies;
    }

    @Override
    public List<ModifierDataWithType> getModifiers() {
        return List.copyOf(modifiers);
    }

    @Override
    public List<ScheduleDataWithType> getStrategies() {
        return List.copyOf(strategies);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ScheduleInfoImpl that = (ScheduleInfoImpl) o;
        return Objects.equals(modifiers, that.modifiers) &&
                Objects.equals(strategies, that.strategies);
    }

    @Override
    public int hashCode() {
        return Objects.hash(modifiers, strategies);
    }

    @Override
    public String toString() {
        return "ScheduleInfoImpl{" +
                "modifiers=" + modifiers +
                ", strategies=" + strategies +
                '}';
    }
}
