package ru.yandex.direct.scheduler.hourglass.implementations.schedule.modifiers;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

import ru.yandex.direct.scheduler.hourglass.schedule.modifiers.ModifierData;
import ru.yandex.direct.scheduler.hourglass.schedule.modifiers.ModifierDataWithType;
import ru.yandex.direct.scheduler.hourglass.schedule.modifiers.ModifierType;

public class ModifierDataWithTypeImpl implements ModifierDataWithType {
    @JsonProperty
    private ModifierType type;
    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type",
            visible = true)
    @JsonSubTypes({
            @JsonSubTypes.Type(value = RandomStartTimeData.class, name = "RANDOM_START_TIME")})
    private ModifierData data;

    @JsonCreator
    public ModifierDataWithTypeImpl(@JsonProperty("type") ModifierType type,
                             @JsonProperty("data") ModifierData data) {
        this.type = type;
        this.data = data;
    }

    @Override
    public ModifierType getType() {
        return type;
    }

    @Override
    public ModifierData getData() {
        return data;
    }

    @Override
    public String toString() {
        return "ModifierDataWithTypeImpl{" +
                "type=" + type +
                ", data=" + data +
                '}';
    }
}
