package ru.yandex.direct.scheduler.hourglass.implementations.schedule.modifiers;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.scheduler.hourglass.schedule.modifiers.ModifierType;
import ru.yandex.direct.scheduler.hourglass.schedule.modifiers.NextRunModifier;
import ru.yandex.direct.scheduler.hourglass.schedule.modifiers.NextRunModifierFactory;

import static java.util.stream.Collectors.toMap;

public class NextRunModifierFactoryImpl implements NextRunModifierFactory {
    private final Map<ModifierType, NextRunModifier> nextRunModifierMap;

    public NextRunModifierFactoryImpl(List<NextRunModifier> nextRunModifiers) {
        this.nextRunModifierMap = nextRunModifiers.stream()
                .collect(toMap(NextRunModifier::getType, modifier -> modifier));
    }

    @Override
    public NextRunModifier getModifier(ModifierType modifierType) {
        if (!nextRunModifierMap.containsKey(modifierType)) {
            throw new IllegalArgumentException("Unknown modifier type: " + modifierType);
        }
        return nextRunModifierMap.get(modifierType);
    }
}
