package ru.yandex.direct.scheduler.hourglass.implementations.schedule.modifiers;

import ru.yandex.direct.scheduler.hourglass.ParamDescription;
import ru.yandex.direct.scheduler.hourglass.TaskDescription;

public class RandomDeltaCalculator {

    /**
     * Вычисляет "случайное" время старта для периодических джобов - от текущего времени до текущего + период запуска
     * Нужно для того, чтобы избежать одновременного старта всех периодических джобов, и регулярных скачков нагрузки
     * При этом для одинаковых параметров вычисляется одинаковое смещение.
     * Времена старта одного задания размазываются по периоду равномерно.
     *
     * @return Рандомизированное смещение для времени запуска джоба
     */

    public long calculateDelta(int period, TaskDescription taskDescription, ParamDescription paramDescription) {
        if (period == 0 || paramDescription.paramGroupSize() == 0) {
            return 0;
        } else {
            return randomDelta(taskDescription.getTaskClass().getName(), paramDescription.paramNumber(),
                    paramDescription.paramGroupSize(), period);
        }
    }

    long randomDelta(String jobClassName, int jobNumberInGroup, int groupSize, int period) {
        long seed = Math.abs(jobClassName.hashCode() % period);

        if (groupSize <= 1) {
            return seed;
        }

        return (seed + period * jobNumberInGroup / groupSize) % period;
    }
}
