package ru.yandex.direct.scheduler.hourglass.implementations.schedule.modifiers;

import java.time.Duration;
import java.time.Instant;

import org.springframework.stereotype.Component;

import ru.yandex.direct.scheduler.hourglass.schedule.modifiers.ModifierData;
import ru.yandex.direct.scheduler.hourglass.schedule.modifiers.ModifierType;
import ru.yandex.direct.scheduler.hourglass.schedule.modifiers.NextRunModifier;

@Component
public class RandomStartTime implements NextRunModifier {
    @Override
    public Instant modify(Instant prevNextRun, ModifierData modifierData) {
        var randomStartTimeData = (RandomStartTimeData) modifierData;
        return plusWithOverflow(prevNextRun, Duration.ofSeconds(randomStartTimeData.getRandomDelta()));
    }

    @Override
    public ModifierType getType() {
        return ModifierType.RANDOM_START_TIME;
    }

    Instant plusWithOverflow(Instant base, Duration delta) {

        if (Instant.MAX.minus(delta).compareTo(base) < 0) {
            return Instant.MAX;
        }

        return base.plus(delta);
    }
}
