package ru.yandex.direct.scheduler.hourglass.implementations.schedule.modifiers;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.scheduler.hourglass.schedule.modifiers.ModifierData;

public class RandomStartTimeData implements ModifierData {

    @JsonProperty
    private final long randomDelta;

    @JsonCreator
    public RandomStartTimeData(@JsonProperty(value = "randomDelta", required = true) long randomDeltaSeconds) {
        randomDelta = randomDeltaSeconds;
    }

    public long getRandomDelta() {
        return randomDelta;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        RandomStartTimeData that = (RandomStartTimeData) o;
        return Objects.equals(randomDelta, that.randomDelta);
    }

    @Override
    public int hashCode() {
        return Objects.hash(randomDelta);
    }

    @Override
    public String toString() {
        return "RandomStartTimeData{" +
                "randomDelta=" + randomDelta +
                '}';
    }
}
