package ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies;

import java.time.Instant;
import java.util.Date;

import javax.annotation.Nonnull;

import org.springframework.scheduling.support.CronSequenceGenerator;
import org.springframework.stereotype.Component;

import ru.yandex.direct.hourglass.TaskProcessingResult;
import ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies.data.ScheduleCronData;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.NextRunCalcStrategy;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleData;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleType;

@Component
public class ByCronExpressionStrategy implements NextRunCalcStrategy {

    @Override
    public Instant getNextDate(@Nonnull TaskProcessingResult taskProcessingResult, ScheduleData scheduleData) {
        var scheduleCronData = (ScheduleCronData) scheduleData;
        var cronSequenceGenerator = new CronSequenceGenerator(scheduleCronData.getExpression());
        Instant lastFinishTime = taskProcessingResult.lastFinishTime();

        if (lastFinishTime == null) {
            lastFinishTime = Instant.now();
        }

        Date out = Date.from(lastFinishTime);
        return cronSequenceGenerator.next(out).toInstant();
    }

    @Override
    public ScheduleType getType() {
        return ScheduleType.CRON;
    }
}
