package ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies;

import java.time.Instant;

import javax.annotation.Nonnull;

import org.springframework.stereotype.Component;

import ru.yandex.direct.hourglass.TaskProcessingResult;
import ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies.data.ScheduleDaemonData;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.NextRunCalcStrategy;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleData;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleType;

@Component
public class DaemonRunStrategy implements NextRunCalcStrategy {

    @Override
    public Instant getNextDate(@Nonnull TaskProcessingResult taskProcessingResult, ScheduleData scheduleData) {
        var scheduleDaemonData = (ScheduleDaemonData) scheduleData;
        Instant lastFinishTime = taskProcessingResult.lastFinishTime();
        if (lastFinishTime == null) {
            lastFinishTime = Instant.now();
        }

        return lastFinishTime.plusSeconds(scheduleDaemonData.getPeriod());
    }

    @Override
    public ScheduleType getType() {
        return ScheduleType.DAEMON;
    }
}
