package ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies;

import java.time.Instant;

import javax.annotation.Nonnull;

import org.springframework.stereotype.Component;

import ru.yandex.direct.hourglass.TaskProcessingResult;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.NextRunCalcStrategy;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleData;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleType;

@Component
public class FarFutureStrategy implements NextRunCalcStrategy {

    @Override
    public Instant getNextDate(@Nonnull TaskProcessingResult taskProcessingResult, ScheduleData scheduleData) {
        return Instant.MAX;
    }

    @Override
    public ScheduleType getType() {
        return ScheduleType.FAR_FUTURE;
    }
}
