package ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.scheduler.hourglass.schedule.strategies.NextRunCalcStrategy;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.NextRunStrategiesFactory;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleType;

import static java.util.stream.Collectors.toMap;

public class NextRunStrategiesFactoryImpl implements NextRunStrategiesFactory {

    private final Map<ScheduleType, NextRunCalcStrategy> nextRunCalcStrategyMap;

    public NextRunStrategiesFactoryImpl(List<NextRunCalcStrategy> nextRunCalcStrategyList) {
        this.nextRunCalcStrategyMap =
                nextRunCalcStrategyList.stream()
                        .collect(toMap(NextRunCalcStrategy::getType, nextRunCalcStrategy -> nextRunCalcStrategy));
    }

    @Override
    public NextRunCalcStrategy getNextRunStrategy(ScheduleType scheduleType) {
        if (!nextRunCalcStrategyMap.containsKey(scheduleType)) {
            throw new IllegalArgumentException("Unknown schedule type " + scheduleType);
        }
        return nextRunCalcStrategyMap.get(scheduleType);
    }
}
