package ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;

import ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies.data.ScheduleCronData;
import ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies.data.ScheduleDaemonData;
import ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies.data.SchedulePeriodicData;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleData;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleDataWithType;
import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleType;

public class ScheduleDataWithTypeImpl implements ScheduleDataWithType {

    @JsonProperty
    private ScheduleType type;
    @JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.EXTERNAL_PROPERTY, property = "type",
            visible = true)
    @JsonSubTypes({
            @JsonSubTypes.Type(value = SchedulePeriodicData.class, name = "PERIODIC"),
            @JsonSubTypes.Type(value = ScheduleDaemonData.class, name = "DAEMON"),
            @JsonSubTypes.Type(value = ScheduleCronData.class, name = "CRON")})
    private ScheduleData data;

    @JsonCreator
    public ScheduleDataWithTypeImpl(@JsonProperty("type") ScheduleType type, @JsonProperty("data") ScheduleData data) {
        this.type = type;
        this.data = data;
    }

    @Override
    public ScheduleType getType() {
        return type;
    }

    @Override
    public ScheduleData getData() {
        return data;
    }

    @Override
    public String toString() {
        return "ScheduleDataWithTypeImpl{" +
                "type=" + type +
                ", data=" + data +
                '}';
    }
}
