package ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies.data;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleData;

public class ScheduleCronData implements ScheduleData {
    @JsonProperty
    private final String expression;

    @JsonCreator
    public ScheduleCronData(
            @JsonProperty(value = "expression", required = true) String cronExpression) {
        this.expression = cronExpression;
    }

    public String getExpression() {
        return expression;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ScheduleCronData that = (ScheduleCronData) o;
        return Objects.equals(expression, that.expression);
    }

    @Override
    public int hashCode() {
        return Objects.hash(expression);
    }
}
