package ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies.data;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleData;

public class ScheduleDaemonData implements ScheduleData {
    @JsonProperty
    private final int period;

    @JsonCreator
    public ScheduleDaemonData(
            @JsonProperty(value = "period", required = true) int period) {
        this.period = period;
    }

    public int getPeriod() {
        return period;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        ScheduleDaemonData that = (ScheduleDaemonData) o;
        return period == that.period;
    }

    @Override
    public int hashCode() {
        return Objects.hash(period);
    }
}
