package ru.yandex.direct.scheduler.hourglass.implementations.schedule.strategies.data;

import java.util.Objects;
import java.util.concurrent.TimeUnit;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.direct.scheduler.hourglass.schedule.strategies.ScheduleData;

public class SchedulePeriodicData implements ScheduleData {
    @JsonProperty
    private final long interval;

    public SchedulePeriodicData(int interval, TimeUnit timeUnit) {
        this(TimeUnit.SECONDS.convert(interval, timeUnit));
    }

    @JsonCreator
    public SchedulePeriodicData(
            @JsonProperty(value = "interval", required = true) long intervalSec) {
        this.interval = intervalSec;
    }

    public long getInterval() {
        return interval;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SchedulePeriodicData that = (SchedulePeriodicData) o;
        return interval == that.interval;
    }

    @Override
    public int hashCode() {
        return Objects.hash(interval);
    }
}
