package ru.yandex.direct.scheduler.hourglass.schedule;

import java.time.Instant;
import java.util.function.Function;

import ru.yandex.direct.hourglass.TaskProcessingResult;

public class NextRunCalculator {
    private final Function<TaskProcessingResult, Instant> calculateFunction;

    public NextRunCalculator(Function<TaskProcessingResult, Instant> calculateFunction) {
        this.calculateFunction = calculateFunction;
    }

    public Instant calculateNextRun(TaskProcessingResult taskProcessingResult) {
        return calculateFunction.apply(taskProcessingResult);
    }
}
