package ru.yandex.direct.scheduler.support;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * С помощью этой аннотации можно указать, какой источник данных о параметрах нужно использовать шедулеру
 * при планировании расписания этой джобы.
 * Если планировщик увидит такую аннотацию на джобе, он позовёт метод {@link #parametersSource()} и
 * по полученному классу вытащит из спрингового контекста бин, у которого вызовёт метод {@link ParametersSource#getAllParamValues()}.
 * После чего запланирует несколько инстансов этой задачи, каждый из которых будет сконфигурирован на работу со своим значением параметра.
 * <p>
 * См. также {@link ParametersSource}
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface ParameterizedBy {
    /**
     * Возвращает класс компонента, который должен быть использован в качестве источника данных о параметрах для этой джобы.
     */
    Class<? extends ParametersSource> parametersSource();

}
