package ru.yandex.direct.scheduler.support;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.scheduler.hourglass.HourglassJob;
import ru.yandex.direct.scheduler.hourglass.TaskParametersMap;

/**
 * Все джобы, кроме демонов, оборачиваются в этот класс
 **/
public class PeriodicJobWrapper implements HourglassJob {
    private static final Logger logger = LoggerFactory.getLogger(PeriodicJobWrapper.class);

    private final BaseDirectJob job;

    public PeriodicJobWrapper(BaseDirectJob job) {
        this.job = job;
    }

    /**
     * Инициализирует задачу контекстом, очищает после выполнения
     **/
    @Override
    public void execute(TaskParametersMap context) {
        job.initialize(context);
        try {
            job.execute(context);
        } finally {
            job.finish();
        }
    }

    /**
     * Запускает graceful degradation задачи.
     */
    @Override
    public void onShutdown() {
        try {
            job.onShutdown();
        } catch (RuntimeException e) {
            logger.error("Error during graceful shutdown on periodic job", e);
        }
    }
}
