package ru.yandex.direct.searchqueryrecommendation

import NAdvMachine.Searchqueryrec
import ru.yandex.direct.utils.FutureUtils
import java.util.concurrent.CompletableFuture

class ParallelBatchedSearchQueryRecommendationClient(val client: SearchQueryRecommendationClient) : BatchedSearchQueryRecommendationClient {

    override fun getSearchQueryRecommendations(requests: List<Searchqueryrec.TSearchQueryRecRequest>): List<Result<Searchqueryrec.TSearchQueryRecResponse>> {
        val futures = requests.map(this::wrap)
        return FutureUtils.completeSafe(futures).get()
    }

    private fun wrap(request: Searchqueryrec.TSearchQueryRecRequest): CompletableFuture<Searchqueryrec.TSearchQueryRecResponse> {
        return CompletableFuture.supplyAsync { client.getSearchQueryRecommendations(request) }
    }
}
