package ru.yandex.direct.searchqueryrecommendation

import NAdvMachine.Searchqueryrec

data class SearchQuery(val query: String, val score: Double, val category: Category) {
    companion object {
        sealed interface Category

        object Exact : Category
        object Alternative : Category
        object Accessory : Category
        object Competitor : Category
        object Broader : Category

        fun from(profile: Searchqueryrec.TSearchQueryRecResponse.TScoredSearchQueryProfile) =
            categories(profile).map { SearchQuery(profile.searchQueryProfile.searchQuery, profile.score.toDouble(), it) }


        // Ручка рекомендации должна каждый запрос относить к одной из категорий. 
        // Но если вдруг она отнесла к нескольким, то дублируем запрос в разных категориях.
        // Если не отнесли ни к одной из категорий, то игнорируем. https://st.yandex-team.ru/DIRECT-148229#60e8775a12339d753b67318e
        private fun categories(profile: Searchqueryrec.TSearchQueryRecResponse.TScoredSearchQueryProfile): List<Category> {
            val buffer = mutableListOf<Category>()
            if (profile.accessoryMatch) buffer += Accessory
            if (profile.broaderMatch) buffer += Broader
            if (profile.alternativeMatch) buffer += Alternative
            if (profile.competitorMatch) buffer += Competitor
            if (profile.exactMatch) buffer += Exact
            return buffer.toList()
        }
    }
}
