package ru.yandex.direct.searchqueryrecommendation

import NAdvMachine.Searchqueryrec
import NAdvMachine.Searchqueryrec.TSearchQueryRecRequest

object SearchQueryRecommendationApiUtil {

    @JvmStatic
    fun buildRequest(url: String?,
                     title: String?,
                     body: String?,
                     regionIds: List<Long>): TSearchQueryRecRequest {

        val plusMinusRegionIds = regionIds.partition { it >= 0 }

        return buildRequest(
            url,
            title,
            body,
            geo = plusMinusRegionIds.first,
            minusGeo = plusMinusRegionIds.second.map(Math::abs)
        )
    }

    @JvmStatic
    fun buildRequest(url: String?,
                     title: String?,
                     body: String?,
                     tPhrases: TSearchQueryRecRequest.TPhrases? = null,
                     geo: List<Long> = emptyList(),
                     minusGeo: List<Long> = emptyList()): TSearchQueryRecRequest {

        val builder =
            TSearchQueryRecRequest.newBuilder()
                .addAllRegionIds(geo)
                .addAllMinusRegionIds(minusGeo)

        url?.let { builder.setBannerURL(it) }
        title?.let { builder.setBannerTitle(it) }
        body?.let { builder.setBannerText(it) }
        tPhrases?.let { builder.setPhrases(it) }

        return builder.build()
    }

    @JvmStatic
    fun tPhrases(minus: List<String> = emptyList(), plus: List<String> = emptyList()) =
        TSearchQueryRecRequest.TPhrases.newBuilder()
            .addAllMinus(minus)
            .addAllPlus(plus)
            .build()

    @JvmStatic
    fun queries(response: Searchqueryrec.TSearchQueryRecResponse): List<SearchQuery> =
        response.candidatesList
            .flatMap { flattenProfiles(it) }
            .flatMap { SearchQuery.from(it) }

    @JvmStatic
    fun flattenProfiles(profile: Searchqueryrec.TSearchQueryRecResponse.TScoredSearchQueryProfile): List<Searchqueryrec.TSearchQueryRecResponse.TScoredSearchQueryProfile> =
        listOf(profile) + profile.subCandidatesList.flatMap { flattenProfiles(it) }

}
