package ru.yandex.direct.searchqueryrecommendation;

import java.io.IOException;
import java.util.Map;

import javax.annotation.ParametersAreNonnullByDefault;

import NAdvMachine.Searchqueryrec;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.util.JsonFormat;
import com.google.protobuf.util.JsonFormat.Printer;
import org.asynchttpclient.Request;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.http.smart.core.Smart;

import static ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors;

@ParametersAreNonnullByDefault
public class SearchQueryRecommendationClient {

    private static final Logger logger = LoggerFactory.getLogger(SearchQueryRecommendationClient.class);
    private static final Printer printer = JsonFormat.printer().omittingInsignificantWhitespace();

    private final SearchQueryRecommendationApi searchQueryRecommendationApi;

    public SearchQueryRecommendationClient(String baseUrl, ParallelFetcherFactory fetcherFactory) {
        searchQueryRecommendationApi = Smart.builder()
                .withParallelFetcherFactory(fetcherFactory)
                .withProfileName("search_query_recommendation_client")
                .withBaseUrl(baseUrl)
                .build()
                .create(SearchQueryRecommendationApi.class);
    }

    public Searchqueryrec.TSearchQueryRecResponse getSearchQueryRecommendations(
            Searchqueryrec.TSearchQueryRecRequest request) throws IOException {
        var call = searchQueryRecommendationApi.getSearchQueryRecommendation(request);
        logRequest(call.getRequest().getAHCRequest());
        var result = call.execute();
        checkResultForErrors(result, IOException::new);
        logResponse(result.getSuccess());
        return result.getSuccess();
    }

    /**
     * Логирование ответа.
     */
    private static void logResponse(Searchqueryrec.TSearchQueryRecResponse response) throws InvalidProtocolBufferException {
        logger.info("Response SearchQuery {}", printer.print(response));
    }

    /**
     * Логирование запроса.
     */
    private static void logRequest(Request request) {
        logger.info("Request SearchQuery {}", requestToString(request));
    }

    private static String requestToString(Request request) {
        StringBuilder sb = new StringBuilder(request.getUrl());
        sb.append("\t");
        sb.append(request.getMethod());
        sb.append("\theaders:");
        if (!request.getHeaders().isEmpty()) {
            for (Map.Entry<String, String> header : request.getHeaders()) {
                sb.append("\t");
                sb.append(header.getKey());
                sb.append(":");
                sb.append(header.getValue());
            }
        }
        sb.append("\tbody: ").append(new String(request.getByteData()));
        return sb.toString();
    }
}
