package ru.yandex.direct.solomon;

import java.util.concurrent.atomic.AtomicReference;

import ru.yandex.monlib.metrics.Metric;
import ru.yandex.monlib.metrics.MetricConsumer;
import ru.yandex.monlib.metrics.MetricType;
import ru.yandex.monlib.metrics.histogram.HistogramCollector;
import ru.yandex.monlib.metrics.registry.MetricId;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

/**
 * Гистограмма, которая может быть не как Counter (с накоплением), а как Gauge (по заданным значениям)
 */
public class GaugeHistogram implements Metric {
    private final AtomicReference<HistogramCollector> collectorRef;

    private GaugeHistogram(HistogramCollector collector) {
        collectorRef = new AtomicReference<>(collector);
    }

    public static void setGaugeHistogram(MetricRegistry registry, MetricId metricId, HistogramCollector collector) {
        GaugeHistogram histogram = (GaugeHistogram) registry.getMetric(metricId);
        if (histogram != null) {
            histogram.collectorRef.set(collector);
        } else {
            histogram = new GaugeHistogram(collector);
            registry.putMetricIfAbsent(metricId, histogram);
        }
    }

    @Override
    public MetricType type() {
        return MetricType.HIST;
    }

    @Override
    public void accept(long tsMillis, MetricConsumer consumer) {
        consumer.onHistogram(tsMillis, collectorRef.get().snapshot());
    }
}
