package ru.yandex.direct.solomon;

import ru.yandex.direct.tracing.Trace;
import ru.yandex.monlib.metrics.histogram.Histograms;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Histogram;

import static ru.yandex.direct.solomon.SolomonUtils.SOLOMON_REGISTRY;

public class SolomonYtMonitorService {

    /**
     * Отправляет метрики в соломон.
     *
     * @param cluster         имя кластера
     * @param spentTimeMillis затраченное время
     * @param success         запрос выполнен успешно/неуспешно
     */
    public void sendMetrics(String cluster, long spentTimeMillis, boolean success) {
        Labels labels = Labels.of("host", cluster,
                "method", Trace.current().getMethod(),
                "external_system", "dynamic_yt_queries",
                "interpreted_status", success ? "success" : "server_error");
        SOLOMON_REGISTRY.rate("requests", labels).inc();

        Histogram sensor = SOLOMON_REGISTRY.histogramRate(
                "response_time_millis",
                labels,
                Histograms.exponential(12, 2, 100)
        );
        sensor.record(spentTimeMillis);
    }
}
