# sql-normalizer - библиотека для нормализации тела sql-запроса для синтаксиса mySQL

### Что умеет

Библиотека приводит тело запроса sql-запроса в диалекте mySQL к нормальной форме, а именно делает следующие вещи:
1. Переводит все символы запроса в нижний регистр;
2. Заменяет все параметры запроса на символ знака вопроса '?' (без кавычек);
3. Нормализует пробельные символы (whitespaces) по следующим правилам:
   * Все пробельные символы схлопываются в один пробел ' ', однако после
   открывающей круглой скобки '(' и перед запятой ',', точкой с запятой ';' или
   закрывающей круглой скобкой ')' удаляются даже одиночные пробелы. Так же удаляются все пробельные
   символы с конца и начала запроса (аналогично ```String.trim()```);
   * Все группы подряд идущих "символов-разделителей"
   ('+', '-', '*' '/', '%', '!', '^', '~', '=', '&gt;', '&lt;', ',', '|'), если они не являются
   частью числа, и не возникает противоречий с предыдущим пунктом, отбиваются пробелами с двух сторон,
   даже если в исходном запросе никаких пробельных символов там не было. Например,
   <nowrap>a&gt;=b&nbsp;+c</nowrap> превратится в <nowrap>a &gt;= b + c</nowrap>;
4. Удаляет все многострочные комментарии в блоках &#47;&#42; &#42;&#47; и однострочные
от '--' до конца строки как будто их вообще там не было. То есть комментарии не учитываются вообще,
и не заменяются на пробел;
5. Заменяет всё, что находится внутри скобок секции ```in (param1, param2 ... paramN)```
на три точки '...' без кавычек;
6. Сортирует все поля во всех запросах внутри select от select до from или конца запроса
и внутри update от set до where, from или конца запроса, включая и учитывая все вложенные select'ы и update'ы.
7. Если нормальная форма получилась слишком большой, то обрезает ее до указанного ограничения в символах или до
указанного количества закрывающих круглых скобок, в зависимости от того, что наступит раньше. Если максимально
допустимая длина запроса наступит раньше, но от последней найденной, в пределах разрешенной длины символов,
закрывающей скобки до максимально допустимой длины останется менее 10% от допустимой длины, то запрос обрежется
по последней найденной скобки. Это позволяет эффективно группировать запросы с огромными перечислениями удаляемых
или добавляемых строк в конце. Если запрос обрезан, добавляет к нему в конце пробел (если обрезалось не на пробеле)
и три точки '...'

Например, запрос:

```mysql
UPDATE managers m
    INNER JOIN
    (
        SELECT /* method:getPetrovs */
            id , name,family,
            exists(select z, x, y from coords where coods.user_id = id)
        FROM users -- get all Petrovs and manager_id in ( some ids )
        WHERE
            family="Petrov" and
            (
                group_id =-1 or manager_id in ( "1", "3", "8" , "92" )
                )
          and salary>-20e-15;
) AS b ON a.name_a = b.name_b
SET validation_check = if(start_dts > end_dts, 'VALID', ''),
    family=b.family
where m.id = 100;
```

Будет преобразован в следующую одиночную строку:

```mysql
update managers m inner join (select exists(select x, y, z from coords where coords.user_id = id), family, id, name from users where family = ? and (group_id = ? or manager_id in (...)) and salary > ?) as b on a.name_a = b.name_b set family = b.family, validation_check = if(start_dts > end_dts, ?, ?) where m.id = ?
```

