package ru.yandex.direct.sql.normalizer;

/**
 * Интерфейс читателя запроса, его инстанс можно получить от класса {@link QueryFieldsSorter#sortQueryFields()}
 */
public interface IQueryReader {
    /**
     * Возвращает сколько всего есть символов в запросе
     * @return количество символов в запросе
     */
    int getLength();

    /**
     * Возвращает следующий символ в запросе
     * @return следующий символ в запросе
     */
    char getNextChar();

    /**
     * Возвращает, есть ли еще непрочитанные символы в запросе или нет
     * @return true, если непрочитанные символы в запросе есть, или false, если нет
     */
    boolean hasNextChar();

    /**
     * Копирует содержимое ридера в символьный буфер
     * @param buffer
     */
    default void copyToBuffer(char[] buffer) {
        for (int i = 0; i < getLength(); i++) {
            buffer[i] = getNextChar();
        }
    }
}

