package ru.yandex.direct.staff.client;

import java.time.LocalDate;
import java.util.Set;

import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.Query;
import ru.yandex.direct.staff.client.model.GapType;
import ru.yandex.direct.staff.client.model.json.GapsSearchResponse;


public interface GapsApi {
    /**
     * найти отсутсвия
     *
     * @param dateFrom дата начала
     * @param dateTo   дата окончания
     * @param logins   список логинов
     * @param gapTypes список типов отсутствий
     * @param limit    лимит отсутствий
     * @return список отсутствий
     */
    @GET("/gaps_find")
    @Json
    Call<GapsSearchResponse> getPersonsByQuery(@Query("date_from") LocalDate dateFrom,
                                               @Query("date_to") LocalDate dateTo,
                                               @Query("person_login") Set<String> logins,
                                               @Query("workflow") Set<GapType> gapTypes,
                                               @Query("limit") int limit);
}
