package ru.yandex.direct.staff.client;

import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.Query;
import ru.yandex.direct.staff.client.model.json.StaffRawInfo;


public interface StaffV3Api {

    /**
     * @param logins Список логинов, о которых запрашивается информация.
     * @param fields Список полей, которые должны быть возвращены.
     * @return
     */
    @POST("/v3/persons")
    @Json
    Call<StaffRawInfo> getPersonsByLogins(@Query("login") String logins, @Query("_fields") String fields);

    /**
     * @param query  Запрос для поиска, см доку https://wiki.yandex-team.ru/staff/apiv3/
     * @param fields Список полей, которые должны быть возвращены.
     * @return
     */
    @POST("/v3/persons")
    @Json
    Call<StaffRawInfo> getPersonsByQuery(@Query("_query") String query,
                                         @Query("_fields") String fields,
                                         @Query("official.is_dismissed") boolean isDismissed,
                                         @Query("_limit") int limit);
}
