package ru.yandex.direct.staff.client.model.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class DepartmentGroup {

    @JsonProperty("department")
    private Department department;

    @JsonProperty("url")
    private String url;

    public Department getDepartment() {
        return department;
    }

    public void setDepartment(Department department) {
        this.department = department;
    }

    public DepartmentGroup withDepartment(Department department) {
        this.department = department;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public DepartmentGroup withUrl(String url) {
        this.url = url;
        return this;
    }
}
