package ru.yandex.direct.staff.client.model.json;

import java.time.LocalDateTime;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.builder.ToStringBuilder;

import static ru.yandex.direct.staff.client.StaffClient.DATE_FORMAT;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class Gap {

    @JsonProperty("comment")
    private String comment;
    @JsonProperty("workflow")
    private String workflow;
    @JsonProperty("work_in_absence")
    private Boolean workInAbsence;
    @JsonProperty("is_selfpaid")
    private Boolean isSelfpaid;
    @JsonProperty("person_login")
    private String personLogin;
    @JsonProperty("date_to")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DATE_FORMAT)
    private LocalDateTime dateTo;
    @JsonProperty("full_day")
    private Boolean fullDay;
    @JsonProperty("id")
    private Integer id;
    @JsonProperty("to_notify")
    private List<Object> toNotify = null;
    @JsonProperty("date_from")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DATE_FORMAT)
    private LocalDateTime dateFrom;

    public String getComment() {
        return comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getWorkflow() {
        return workflow;
    }

    public void setWorkflow(String workflow) {
        this.workflow = workflow;
    }

    public Boolean getWorkInAbsence() {
        return workInAbsence;
    }

    public void setWorkInAbsence(Boolean workInAbsence) {
        this.workInAbsence = workInAbsence;
    }

    public Boolean getIsSelfpaid() {
        return isSelfpaid;
    }

    public void setIsSelfpaid(Boolean isSelfpaid) {
        this.isSelfpaid = isSelfpaid;
    }

    public String getPersonLogin() {
        return personLogin;
    }

    public void setPersonLogin(String personLogin) {
        this.personLogin = personLogin;
    }

    public LocalDateTime getDateTo() {
        return dateTo;
    }

    public void setDateTo(LocalDateTime dateTo) {
        this.dateTo = dateTo;
    }

    public Boolean getFullDay() {
        return fullDay;
    }

    public void setFullDay(Boolean fullDay) {
        this.fullDay = fullDay;
    }

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public List<Object> getToNotify() {
        return toNotify;
    }

    public void setToNotify(List<Object> toNotify) {
        this.toNotify = toNotify;
    }

    public LocalDateTime getDateFrom() {
        return dateFrom;
    }

    public void setDateFrom(LocalDateTime dateFrom) {
        this.dateFrom = dateFrom;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this).append("comment", comment).append("workflow", workflow).append(
                "workInAbsence", workInAbsence).append("isSelfpaid", isSelfpaid).append("personLogin", personLogin).append("dateTo", dateTo).append("fullDay", fullDay).append("id", id).append("toNotify", toNotify).append("dateFrom", dateFrom).toString();
    }

}
