package ru.yandex.direct.staff.client.model.json;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonInclude(JsonInclude.Include.NON_NULL)
public class PersonInfo {

    @JsonProperty("work_phone")
    private Integer workPhone;
    @JsonProperty("login")
    private String login;
    @JsonProperty("work_email")
    private String workEmail;
    @JsonProperty("name")
    private Name name;
    @JsonProperty("department_group")
    private DepartmentGroup departmentGroup;
    @JsonProperty("accounts")
    private List<Account> accounts;

    public Integer getWorkPhone() {
        return workPhone;
    }

    public void setWorkPhone(Integer workPhone) {
        this.workPhone = workPhone;
    }

    public PersonInfo withWorkPhone(Integer workPhone) {
        this.workPhone = workPhone;
        return this;
    }

    public String getLogin() {
        return login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public PersonInfo withLogin(String login) {
        this.login = login;
        return this;
    }

    public String getWorkEmail() {
        return workEmail;
    }

    public void setWorkEmail(String workEmail) {
        this.workEmail = workEmail;
    }

    public PersonInfo withWorkEmail(String workEmail) {
        this.workEmail = workEmail;
        return this;
    }

    public Name getName() {
        return name;
    }

    public void setName(Name name) {
        this.name = name;
    }

    public PersonInfo withName(Name name) {
        this.name = name;
        return this;
    }

    public DepartmentGroup getDepartmentGroup() {
        return departmentGroup;
    }

    public void setDepartmentGroup(DepartmentGroup departmentGroup) {
        this.departmentGroup = departmentGroup;
    }

    public PersonInfo withDepartmentGroup(DepartmentGroup departmentGroup) {
        this.departmentGroup = departmentGroup;
        return this;
    }

    public List<Account> getAccounts() {
        return accounts;
    }

    public void setAccounts(List<Account> accounts) {
        this.accounts = accounts;
    }

    public PersonInfo withAccounts(List<Account> accounts) {
        this.accounts = accounts;
        return this;
    }
}
