package ru.yandex.direct.takeout.client;

import java.io.File;
import java.util.Set;

import org.asynchttpclient.request.body.multipart.FilePart;

import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.asynchttp.Result;
import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.core.Smart;
import ru.yandex.direct.http.smart.http.Field;
import ru.yandex.direct.http.smart.http.FormUrlEncoded;
import ru.yandex.direct.http.smart.http.Multipart;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.Part;
import ru.yandex.direct.http.smart.http.Query;
import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.direct.tvm.TvmService;

import static ru.yandex.direct.http.smart.error.ErrorUtils.checkResultForErrors;

public class TakeoutClient {
    public static final String CONSUMER = "direct";
    private final Api api;

    public TakeoutClient(String url, TvmIntegration tvmIntegration, TvmService tvmService,
                         ParallelFetcherFactory parallelFetcherFactory) {
        api = createApi(url, tvmIntegration, tvmService, parallelFetcherFactory);
    }

    private Api createApi(String url, TvmIntegration tvmIntegration, TvmService tvmService,
                          ParallelFetcherFactory parallelFetcherFactory) {
        return Smart.builder()
                .withParallelFetcherFactory(parallelFetcherFactory)
                .withProfileName("takeout_client")
                .useTvm(tvmIntegration, tvmService)
                .withBaseUrl(url)
                .build()
                .create(Api.class);
    }

    public TakeoutResponse uploadFile(File file, String jobId) {
        Result<TakeoutResponse> result = api.uploadFile(CONSUMER, jobId, new FilePart("file", file)).execute();
        checkResultForErrors(result, TakeoutClientException::new);
        return result.getSuccess();
    }

    public TakeoutResponse done(Set<String> fileNames, String jobId) {
        Result<TakeoutResponse> result = api.done(CONSUMER, jobId, fileNames).execute();
        checkResultForErrors(result, TakeoutClientException::new);
        return result.getSuccess();
    }

    public interface Api {
        @POST("/upload/")
        @Multipart
        @Json
        Call<TakeoutResponse> uploadFile(@Query("consumer") String consumer, @Part("job_id") String jobId,
                                         @Part FilePart filePart);

        @POST("/upload/done/")
        @FormUrlEncoded
        @Json
        Call<TakeoutResponse> done(@Query("consumer") String consumer, @Field("job_id") String jobId,
                                   @Field("filename") Set<String> fileNames);
    }
}
