package ru.yandex.direct.telegram.client

import com.fasterxml.jackson.annotation.JsonInclude
import com.fasterxml.jackson.databind.ObjectMapper
import com.fasterxml.jackson.databind.PropertyNamingStrategy
import ru.yandex.direct.http.smart.converter.CustomJsonResponseConverter
import ru.yandex.direct.http.smart.converter.RequestBodyConverter
import ru.yandex.direct.http.smart.request.Content
import ru.yandex.direct.http.smart.request.StringContent
import ru.yandex.direct.utils.JsonUtils

private val telegramObjectMapper = JsonUtils.MAPPER.copy()
    .setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE)
    .setDefaultPropertyInclusion(JsonInclude.Include.NON_NULL)

class TelegramResponseConverter : CustomJsonResponseConverter<Any>() {
    override fun buildObjectMapper(): ObjectMapper = telegramObjectMapper
}

class TelegramRequestConverter<R> : RequestBodyConverter<R> {
    override fun convert(value: R): Content = StringContent(telegramObjectMapper.writeValueAsString(value))
}
