package ru.yandex.direct.telegram.client.api

import ru.yandex.direct.http.smart.annotations.ResponseHandler
import ru.yandex.direct.http.smart.core.Call
import ru.yandex.direct.http.smart.http.Body
import ru.yandex.direct.http.smart.http.Headers
import ru.yandex.direct.http.smart.http.POST
import ru.yandex.direct.telegram.client.TelegramRequestConverter
import ru.yandex.direct.telegram.client.TelegramResponseConverter

interface TelegramApi {

    @POST("getUpdates")
    @ResponseHandler(
        parserClass = TelegramResponseConverter::class,
        // https://core.telegram.org/api/errors#error-constructors
        expectedCodes = [200, 400, 403],
    )
    @Headers("Content-Type: application/json")
    fun getUpdates(
        @Body(converter = TelegramRequestConverter::class)
        request: GetUpdatesRequest,
    ): Call<TelegramResponse<List<Update>>>

    @POST("getMe")
    @ResponseHandler(
        parserClass = TelegramResponseConverter::class,
        // https://core.telegram.org/api/errors#error-constructors
        expectedCodes = [200, 400, 403],
    )
    @Headers("Content-Type: application/json")
    fun getMe(): Call<TelegramResponse<User>>

    @POST("sendMessage")
    @ResponseHandler(
        parserClass = TelegramResponseConverter::class,
        // https://core.telegram.org/api/errors#error-constructors
        expectedCodes = [200, 400, 403],
    )
    @Headers("Content-Type: application/json")
    fun sendMessage(
        @Body(converter = TelegramRequestConverter::class)
        request: SendMessageRequest,
    ): Call<TelegramResponse<Message>>

    @POST("sendChatAction")
    @ResponseHandler(
        parserClass = TelegramResponseConverter::class,
        // https://core.telegram.org/api/errors#error-constructors
        expectedCodes = [200, 400, 403],
    )
    @Headers("Content-Type: application/json")
    fun sendChatAction(
        @Body(converter = TelegramRequestConverter::class)
        request: SendChatActionRequest,
    ): Call<TelegramResponse<Boolean>>

    @POST("answerCallbackQuery")
    @ResponseHandler(
        parserClass = TelegramResponseConverter::class,
        // https://core.telegram.org/api/errors#error-constructors
        expectedCodes = [200, 400, 403],
    )
    @Headers("Content-Type: application/json")
    fun answerCallbackQuery(
        @Body(converter = TelegramRequestConverter::class)
        request: AnswerCallbackQueryRequest,
    ): Call<TelegramResponse<Boolean>>

    @POST("editMessageText")
    @ResponseHandler(
        parserClass = TelegramResponseConverter::class,
        // https://core.telegram.org/api/errors#error-constructors
        expectedCodes = [200, 400, 403],
    )
    @Headers("Content-Type: application/json")
    fun editMessageText(
        @Body(converter = TelegramRequestConverter::class)
        request: EditMessageTextRequest,
    ): Call<TelegramResponse<Void>>
}
