package ru.yandex.direct.telegram.client.api

import ru.yandex.direct.asynchttp.Result
import ru.yandex.direct.http.smart.core.Call
import ru.yandex.direct.http.smart.error.ErrorUtils
import ru.yandex.direct.telegram.client.TelegramClientException

/**
 * [Документация](https://core.telegram.org/bots/api#making-requests)
 */
data class TelegramResponse<T>(
    val ok: Boolean,
    private val result: T?,
    private val description: String?,
    private val errorCode: Int?,
    private val parameters: ResponseParameters?,
) {
    fun checked(): T {
        checkError()
        return result!!
    }

    private fun checkError() {
        if (ok) return
        when {
            description != null && errorCode != null ->
                throw TelegramClientException("Telegram api call failed with error code $errorCode and description '$description'")
            description != null ->
                throw TelegramClientException("Telegram api call failed with description '$description'")
            errorCode != null ->
                throw TelegramClientException("Telegram api call failed with errorCode $errorCode")
        }
    }
}

fun <T> Call<TelegramResponse<T>>.executeTelegram(): TelegramResponse<T> {
    val response: Result<TelegramResponse<T>> = execute()
    ErrorUtils.checkResultForErrors(response, { TelegramClientException(it) })
    return response.success
}

fun <T> Call<TelegramResponse<T>>.executeChecked(): T = executeTelegram().checked()
