package ru.yandex.direct.telephony.client;

import org.asynchttpclient.request.body.multipart.PartBase;

import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.Headers;
import ru.yandex.direct.http.smart.http.Multipart;
import ru.yandex.direct.http.smart.http.POST;
import ru.yandex.direct.http.smart.http.Part;
import ru.yandex.direct.telephony.client.model.GetTicketResponse;
import ru.yandex.direct.telephony.client.model.PlaybackUploadResponse;

public interface SmartApi {
    @POST("/tickets")
    @Headers("Content-type: application/json")
    @Json
    Call<GetTicketResponse> tickets();

    @POST("/playbacks")
    @Headers("Content-Type: multipart/form-data")
    @Multipart
    @Json
    Call<PlaybackUploadResponse> playbacks(@Part PartBase playbackData);
}
