package ru.yandex.direct.telephony.client;

import java.util.Collection;
import java.util.List;

import ru.yandex.direct.telephony.client.model.TelephonyPhoneRequest;
import ru.yandex.telephony.backend.lib.proto.telephony_platform.ServiceNumber;
import ru.yandex.telephony.backend.lib.proto.telephony_platform.UpdateServiceSettingsRequest;

/**
 * Подробное описание API Телефонии: https://wiki.yandex-team.ru/telephony/telephony-platform-calltracking/#grpcapi
 *
 * Перед каждым gRPC-запросом необходимо получить тикет, используя HTTP метод {@link SmartApi#tickets()}.
 * В тикете будет адрес хоста инстанса grpc api, на который необходимо отправить запрос и идентификатор тикета,
 * который надо добавить в meta X-Telephony-Ticket-Id
 */
public interface TelephonyGrpcApi {

    /**
     * Получение свободного ABC номера
     * @param regionCode - код региона для запрашиваемого телефона.
     * @return Свободный номер в Телефонии
     */
    ServiceNumber getServiceNumber(String regionCode);

    /**
     * Получение свободного DEF номера
     * @return Свободный номер в Телефони
     */
    ServiceNumber getServiceNumber();

    /**
     * Получение номеров Телефонии по serviceId
     */
    List<ServiceNumber> getServiceNumberByIds(Collection<String> telephonyServiceIds);

    /**
     * Получение номеров, привязанных на клиента.
     */
    List<ServiceNumber> getClientServiceNumbers(long clientId);

    List<ServiceNumber> getServiceNumbersBatch(int offset, int count);

    /**
     * Привязать номер к клиенту (необходимо знать telephonyServiceId).
     */
    void linkServiceNumber(long clientId, TelephonyPhoneRequest telephonyPhone);

    /**
     * Привязать номер к клиенту с учетом версии (необходимо знать telephonyServiceId).
     */
    void linkServiceNumber(long clientId, TelephonyPhoneRequest telephonyPhone, int version);

    /**
     * Отвязать номер от клиента.
     */
    void unlinkServiceNumber(String serviceNumberId, boolean shouldSendToQuarantine);

    /**
     * Обновить настройки создания редиректов.
     */
    void updateServiceSettings(UpdateServiceSettingsRequest updateSettings);
}
