package ru.yandex.direct.telephony.client.model;

import java.util.Objects;

import javax.annotation.Nullable;

import ru.yandex.telephony.backend.lib.proto.telephony_platform.CallRecordingScope;

public class TelephonyPhoneRequest {

    private String redirectPhone;

    private String telephonyServiceId;

    private Long permalinkId;

    private Long counterId;

    @Nullable
    private String beforeConnectedPlaybackId;

    @Nullable
    private String promptPlaybackId;

    @Nullable
    private String beforeConversationPlaybackID;

    @Nullable
    private Boolean disableProxyBridgedCallerNum;

    @Nullable
    private CallRecordingScope callRecordingScope;

    public String getRedirectPhone() {
        return redirectPhone;
    }

    public TelephonyPhoneRequest withRedirectPhone(String redirectPhone) {
        this.redirectPhone = redirectPhone;
        return this;
    }

    public String getTelephonyServiceId() {
        return telephonyServiceId;
    }

    public TelephonyPhoneRequest withTelephonyServiceId(String telephonyServiceId) {
        this.telephonyServiceId = telephonyServiceId;
        return this;
    }

    public Long getPermalinkId() {
        return permalinkId;
    }

    public TelephonyPhoneRequest withPermalinkId(Long permalinkId) {
        this.permalinkId = permalinkId;
        return this;
    }

    public Long getCounterId() {
        return counterId;
    }

    public TelephonyPhoneRequest withCounterId(Long counterId) {
        this.counterId = counterId;
        return this;
    }

    @Nullable
    public String getBeforeConnectedPlaybackId() {
        return beforeConnectedPlaybackId;
    }

    public void withBeforeConnectedPlaybackId(String beforeConnectedPlaybackId) {
        this.beforeConnectedPlaybackId = beforeConnectedPlaybackId;
    }

    @Nullable
    public String getPromptPlaybackId() {
        return promptPlaybackId;
    }

    public void withPromptPlaybackId(String promptPlaybackId) {
        this.promptPlaybackId = promptPlaybackId;
    }

    @Nullable
    public String getBeforeConversationPlaybackID() {
        return beforeConversationPlaybackID;
    }

    public void setBeforeConversationPlaybackID(@Nullable String beforeConversationPlaybackID) {
        this.beforeConversationPlaybackID = beforeConversationPlaybackID;
    }

    @Nullable
    public Boolean getDisableProxyBridgedCallerNum() {
        return disableProxyBridgedCallerNum;
    }

    public TelephonyPhoneRequest withDisableProxyBridgedCallerNum(@Nullable Boolean disableProxyBridgedCallerNum) {
        this.disableProxyBridgedCallerNum = disableProxyBridgedCallerNum;
        return this;
    }

    @Nullable
    public CallRecordingScope getCallRecordingScope() {
        return callRecordingScope;
    }

    public TelephonyPhoneRequest withCallRecordingScope(@Nullable CallRecordingScope callRecordingScope) {
        this.callRecordingScope = callRecordingScope;
        return this;
    }

    public CallSource getCallSource() {
        // если пермалинк не указан то это коллтрекинг на сайте
        if (permalinkId == null || permalinkId == 0L) {
            return CallSource.SITE;
        }
        return CallSource.ADV;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        TelephonyPhoneRequest request = (TelephonyPhoneRequest) o;
        return Objects.equals(redirectPhone, request.redirectPhone) &&
                Objects.equals(telephonyServiceId, request.telephonyServiceId) &&
                Objects.equals(permalinkId, request.permalinkId) &&
                Objects.equals(counterId, request.counterId) &&
                Objects.equals(beforeConnectedPlaybackId, request.beforeConnectedPlaybackId) &&
                Objects.equals(promptPlaybackId, request.promptPlaybackId) &&
                Objects.equals(beforeConversationPlaybackID, request.beforeConversationPlaybackID) &&
                Objects.equals(disableProxyBridgedCallerNum, request.disableProxyBridgedCallerNum) &&
                Objects.equals(callRecordingScope, request.callRecordingScope);
    }

    @Override
    public int hashCode() {
        return Objects.hash(redirectPhone, telephonyServiceId, permalinkId, counterId,
                beforeConnectedPlaybackId, promptPlaybackId, beforeConversationPlaybackID,
                disableProxyBridgedCallerNum, callRecordingScope);
    }

    @Override
    public String toString() {
        return "TelephonyPhoneRequest{" +
                "redirectPhone=" + redirectPhone +
                ", telephonyServiceId=" + telephonyServiceId +
                ", permalinkId=" + permalinkId +
                ", counterId=" + counterId +
                ", beforeConnectedPlaybackId=" + beforeConnectedPlaybackId +
                ", promptPlaybackId=" + promptPlaybackId +
                ", beforeConversationPlaybackID=" + beforeConversationPlaybackID +
                ", disableProxyBridgedCallerNum=" + disableProxyBridgedCallerNum +
                ", callRecordingScope=" + callRecordingScope +
                '}';
    }
}
