package ru.yandex.direct.libs.timetarget;

import java.time.LocalDate;

/**
 * Интерфейс производственного календаря
 */
public interface ProductionCalendar {

    /**
     * Позволяет определить день недели с точки зрения рабочий/нерабочий.
     *
     * @param date дата, для которой необходимо определить, каким днём она является
     * @return {@link WeekdayType} пн-вс, или праздничный, или рабочий выходной
     */
    WeekdayType getWeekdayType(LocalDate date);

}
