package ru.yandex.direct.libs.timetarget;

public class TimeTargetUtils {
    public static final Long DEFAULT_TIMEZONE = 130L; // Moscow timezone
    public static final Long UA_DEFAULT_TIMEZONE = 61L; // Kiev timezone
    /**
     * По умолчанию показываем 24х7 со стандартным коэффициентом
     */
    private static final TimeTarget TIME_TARGET_24_7 = TimeTarget.parseRawString(
            "1ABCDEFGHIJKLMNOPQRSTUVWX" +
            "2ABCDEFGHIJKLMNOPQRSTUVWX" +
            "3ABCDEFGHIJKLMNOPQRSTUVWX" +
            "4ABCDEFGHIJKLMNOPQRSTUVWX" +
            "5ABCDEFGHIJKLMNOPQRSTUVWX" +
            "6ABCDEFGHIJKLMNOPQRSTUVWX" +
            "7ABCDEFGHIJKLMNOPQRSTUVWX");

    private static final TimeTarget TIME_TARGET_24_7_USE_WORKING_WEEKEND = TimeTarget.parseRawString(
            "1ABCDEFGHIJKLMNOPQRSTUVWX" +
            "2ABCDEFGHIJKLMNOPQRSTUVWX" +
            "3ABCDEFGHIJKLMNOPQRSTUVWX" +
            "4ABCDEFGHIJKLMNOPQRSTUVWX" +
            "5ABCDEFGHIJKLMNOPQRSTUVWX" +
            "6ABCDEFGHIJKLMNOPQRSTUVWX" +
            "7ABCDEFGHIJKLMNOPQRSTUVWX" +
            "9");

    public static HoursCoef defaultTargetingHoursCoefs() {
        HoursCoef defaultCoefs = new HoursCoef();
        for (int h = 0; h < 24; h++) {
            defaultCoefs.setCoef(h, TimeTarget.PredefinedCoefs.USUAL.getValue());
        }
        return defaultCoefs;
    }

    public static boolean isZeroCoefs(HoursCoef hoursCoef) {
        if (hoursCoef == null) {
            return true;
        }
        for (int h = 0; h < 24; h++) {
            if (hoursCoef.getCoefForHour(h) != TimeTarget.PredefinedCoefs.ZERO.getValue()) {
                return false;
            }
        }
        return true;
    }

    public static TimeTarget defaultTimeTarget() {
        return TIME_TARGET_24_7;
    }

    public static TimeTarget timeTarget24x7() {
        return TIME_TARGET_24_7;
    }

    public static TimeTarget timeTarget24x7UseWorkingWeekend() {
        return TIME_TARGET_24_7_USE_WORKING_WEEKEND;
    }
}
