package ru.yandex.direct.libs.timetarget;

import java.util.Map;
import java.util.Optional;

import javax.annotation.Nonnull;

import one.util.streamex.StreamEx;

/**
 * Тип дня недели, для которого можно задать правила временного таргетинга.
 * <p>
 * Кроме обычных дней недели, сюда включены праздники и рабочие выходные
 */
public enum WeekdayType {
    MONDAY(1),
    TUESDAY(2),
    WEDNESDAY(3),
    THURSDAY(4),
    FRIDAY(5),
    SATURDAY(6),
    SUNDAY(7),
    HOLIDAY(8),
    WORKING_WEEKEND(9);

    private static final Map<Integer, WeekdayType> WEEKDAYS_BY_ID;

    static {
        WEEKDAYS_BY_ID = StreamEx.of(values()).mapToEntry(WeekdayType::getInternalNum).invert().toMap();
    }

    private int internalNum;

    WeekdayType(int internalNum) {
        this.internalNum = internalNum;
    }

    @Nonnull
    public static WeekdayType getById(Integer id) {
        return Optional.ofNullable(WEEKDAYS_BY_ID.get(id))
                .orElseThrow(() -> new IllegalArgumentException("Can't find weekday by id " + id));
    }

    public int getInternalNum() {
        return internalNum;
    }
}
