package ru.yandex.direct.tracing;

import java.util.function.Supplier;

import ru.yandex.direct.tracing.data.TraceData;

/**
 * Fake trace that doesn't capture any data
 * <p>
 * It is used to provide user code with a valid trace object even when service call is not being traced, alleviating
 * the need of additional checks.
 */
public class DummyTrace implements Trace {
    public static final String UNKNOWN_VALUE = "unknown";

    private static final DummyTrace INSTANCE = new DummyTrace();

    private DummyTrace() {
    }

    @Override
    public long getTraceId() {
        return 0;
    }

    @Override
    public long getParentId() {
        return 0;
    }

    @Override
    public long getSpanId() {
        return 0;
    }

    @Override
    public String getService() {
        return UNKNOWN_VALUE;
    }

    @Override
    public String getMethod() {
        return UNKNOWN_VALUE;
    }

    @Override
    public String getTags() {
        return null;
    }

    @Override
    public int getSamplerate() {
        return 0;
    }

    @Override
    public int getTtl() {
        return 0;
    }

    @Override
    public boolean getSkipInterception() {
        return false;
    }

    @Override
    public double getCpuTime() {
        return 0;
    }

    @Override
    public void setTraceId(long traceId) {
        // not a real trace
    }

    @Override
    public void setParentId(long parentId) {
        // not a real trace
    }

    @Override
    public void setSpanId(long spanId) {
        // not a real trace
    }

    @Override
    public void setService(String service) {
        // not a real trace
    }

    @Override
    public void setMethod(String method) {
        // not a real trace
    }

    @Override
    public void setTags(String tags) {
        // not a real trace
    }

    @Override
    public void setSamplerate(int samplerate) {
        // not a real trace
    }

    @Override
    public void setTtl(int ttl) {
        // not a real trace
    }

    @Override
    public void setSkipInterception(boolean skipInterception) {
        // not a real trace
    }

    @Override
    public double elapsed() {
        return 0;
    }

    @Override
    public TraceProfile profile(String func, String tags, long objCount) {
        return new DummyTraceProfile(getService(), getMethod(), func, tags, objCount);
    }

    @Override
    public TraceChild child(String service, String method) {
        return new DummyTraceChild(service, method);
    }

    @Override
    public void mark(String message) {
        // not a real trace
    }

    @Override
    public void annotate(String key, String value) {
        // not a real trace
    }

    @Override
    public TraceData snapshot(boolean partial) {
        return null;
    }

    @Override
    public void close() {
        // not a real trace
    }

    @Override
    public Runnable wrap(Runnable runnable) {
        return runnable;
    }

    @Override
    public <V> Supplier<V> wrap(Supplier<V> callable) {
        return callable;
    }

    /**
     * Returns the global DummyTrace object
     */
    public static DummyTrace instance() {
        return INSTANCE;
    }
}
