package ru.yandex.direct.tracing;

import ru.yandex.direct.tracing.util.TraceUtil;

/**
 * Fake child object that doesn't capture any data
 * <p>
 * Tracing parameters returned by this object form a valid root trace on the remote side.
 */
public class DummyTraceChild implements TraceChild {
    private long childStart = System.nanoTime();
    private long spanId;
    private String service;
    private String method;

    public DummyTraceChild(String service, String method) {
        this(TraceUtil.randomId(), service, method);
    }

    public DummyTraceChild(long spanId, String service, String method) {
        this.spanId = spanId;
        this.service = service;
        this.method = method;
    }

    @Override
    public long getTraceId() {
        return spanId;
    }

    @Override
    public long getParentId() {
        return 0;
    }

    @Override
    public long getSpanId() {
        return spanId;
    }

    @Override
    public String getService() {
        return service;
    }

    @Override
    public String getMethod() {
        return method;
    }

    @Override
    public int getTtl() {
        return 0;
    }

    @Override
    public double startedAt() {
        return 0;
    }

    @Override
    public double elapsed() {
        return TraceUtil.secondsFromNanoseconds(System.nanoTime() - childStart);
    }

    @Override
    public void close() {
        // not a real child
    }
}
