package ru.yandex.direct.tracing;

/**
 * Fake profile object that doesn't capture any data
 */
public class DummyTraceProfile implements TraceProfile {
    private String service;
    private String method;
    private String func;
    private String tags;
    private long objCount;

    public DummyTraceProfile(String service, String method, String func, String tags, long objCount) {
        this.service = service;
        this.method = method;
        this.func = func;
        this.tags = tags;
        this.objCount = objCount;
    }

    @Override
    public String getService() {
        return service;
    }

    @Override
    public String getMethod() {
        return method;
    }

    @Override
    public String getFunc() {
        return func;
    }

    @Override
    public String getTags() {
        return tags;
    }

    @Override
    public long getObjCount() {
        return objCount;
    }

    @Override
    public void close() {
        // not a real profile
    }

    @Override
    public void addCommandOnClose(Runnable cmd) {
        // not a real profile
    }
}
