package ru.yandex.direct.tracing;

/**
 * Object used for tracking remote method calls
 */
public interface TraceChild extends AutoCloseable {
    /**
     * Returns trace id for the remote method call
     */
    long getTraceId();

    /**
     * Returns parent id for the remote method call
     */
    long getParentId();

    /**
     * Returns span id for the remote method call
     */
    long getSpanId();

    /**
     * Returns the name of the remote service
     */
    String getService();

    /**
     * Returns the name of the remote method
     */
    String getMethod();

    /**
     * Returns tll value for the remote method call
     */
    int getTtl();

    /**
     * Returns relative time since the start of the trace when the remote method call started
     */
    double startedAt();

    /**
     * Returns elapsed time since the start of the remote method call
     */
    double elapsed();

    /**
     * Signals the end of the remote method call
     */
    @Override
    void close();
}
