package ru.yandex.direct.tracing;

import java.util.concurrent.Future;

/**
 * Объект, который умеет корректно обрабатывать завершение трейса:
 * - удаляет его из стека
 * - удаляет задачу на периодический сброс состояния
 * - сбрасывает данные с лог
 * <p>
 * Создаётся в TraceHelper::guard
 */
public class TraceGuard implements AutoCloseable {
    private final TraceLogger traceLogger;
    private final Trace trace;
    private final Future registration;
    private boolean postponed = false;

    TraceGuard(TraceLogger traceLogger, Trace trace, Future registration) {
        this.traceLogger = traceLogger;
        this.trace = trace;
        this.registration = registration;
    }

    /**
     * Откладывает завершение трейса на более поздний срок
     */
    public void postpone() {
        postponed = true;
    }

    /**
     * Завершает трейс после вызова postpone
     */
    public void finish() {
        registration.cancel(false);
        traceLogger.dump(trace);
    }

    @Override
    public void close() {
        try {
            Trace.pop();
        } finally {
            if (!postponed) {
                finish();
            }
        }
    }
}
