package ru.yandex.direct.tracing;

import java.util.Objects;

import org.slf4j.MDC;

import ru.yandex.direct.tracing.util.HostnameUtils;

/**
 * Пробрасывает параметры {@link Trace} в {@link MDC}
 */
public class TraceMdcAdapter {

    public static final String HOSTNAME_KEY = "traceHostname";
    public static final String SERVICE_KEY = "traceService";
    public static final String METHOD_KEY = "traceMethod";
    public static final String TRACE_ID_KEY = "traceId";
    public static final String PARENT_ID_KEY = "traceParentId";
    public static final String SPAN_ID_KEY = "traceSpanId";

    private TraceMdcAdapter() {
    }

    /**
     * Пробрасывает параметры в {@link MDC}.
     * Если стек трейсинга пустой, то {@link MDC} очищается
     *
     * @param trace объект для передачи в MDC
     * @throws NullPointerException в случае, если {@code trace == null}
     */
    public static void updateMDC(Trace trace) {
        Objects.requireNonNull(trace, "trace is mandatory");
        if(DummyTrace.instance().equals(trace)) {
            MDC.clear();
            return;
        }
        MDC.put(HOSTNAME_KEY, HostnameUtils.hostname());
        MDC.put(SERVICE_KEY, trace.getService());
        MDC.put(METHOD_KEY, trace.getMethod());
        MDC.put(TRACE_ID_KEY, String.valueOf(trace.getTraceId()));
        MDC.put(PARENT_ID_KEY, String.valueOf(trace.getParentId()));
        MDC.put(SPAN_ID_KEY, String.valueOf(trace.getSpanId()));
    }
}
