package ru.yandex.direct.tracing;

/**
 * Object used for tracking function calls
 */
public interface TraceProfile extends AutoCloseable {
    /**
     * Returns service name of the function call
     */
    String getService();

    /**
     * Returns method name of the function call
     */
    String getMethod();

    /**
     * Returns the name of the function call
     */
    String getFunc();

    /**
     * Returns tags for the function call
     */
    String getTags();

    /**
     * Returns number of objects the function is working on
     */
    long getObjCount();

    /**
     * Signals the end of the function call
     */
    @Override
    void close();

    /**
     * Add custom commands for executing on profile close
     */
    void addCommandOnClose(Runnable cmd);
}
